/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDListRenderer;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Font;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDList
extends JList {
    private static final long serialVersionUID = 1L;
    private QDListRenderer m_renderer = null;

    public QDList(ListModel listModel) {
        super(listModel);
        this.initLook();
    }

    public QDList(Object[] objectArray) {
        super(objectArray);
        this.initLook();
    }

    public QDList(Vector<?> vector) {
        super(vector);
        this.initLook();
    }

    public QDList() {
        super(new DefaultListModel());
        this.initLook();
    }

    public void setIcon(ImageIcon imageIcon) {
        this.m_renderer.setIcon(imageIcon);
    }

    private void initLook() {
        this.setBackground(QDStdUI.getBackground());
        this.m_renderer = new QDListRenderer();
        this.setCellRenderer(this.m_renderer);
    }

    @Override
    public void setFont(Font font) {
        if (this.m_renderer != null) {
            this.m_renderer.setFont(font);
        }
    }

    public void setSingleSelect() {
        this.setSelectionMode(0);
    }

    public void useSmallItems(boolean bl) {
        this.m_renderer.useStdSize(!bl);
    }

    public DefaultListModel getData() {
        return (DefaultListModel)super.getModel();
    }

    public boolean containsItem(String string) {
        DefaultListModel defaultListModel = this.getData();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!defaultListModel.get(i).toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object getItem(String string) {
        DefaultListModel defaultListModel = this.getData();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = defaultListModel.get(i);
            if (!e.toString().equals(string)) continue;
            return e;
        }
        return null;
    }

    public boolean removeItem(String string) {
        DefaultListModel defaultListModel = this.getData();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!defaultListModel.get(i).toString().equals(string)) continue;
            defaultListModel.remove(i);
            return true;
        }
        return false;
    }

    public void moveSelectedUp() {
        int n;
        DefaultListModel defaultListModel = this.getData();
        if (defaultListModel.getSize() > 1 && (n = this.getSelectedIndex()) > 0) {
            Object e = defaultListModel.remove(n);
            defaultListModel.add(--n, e);
            this.setSelectedIndex(n);
        }
    }

    public void moveSelectedDown() {
        int n;
        DefaultListModel defaultListModel = this.getData();
        int n2 = defaultListModel.getSize();
        if (n2 > 1 && (n = this.getSelectedIndex()) >= 0 && n < n2 - 1) {
            Object e = defaultListModel.remove(n);
            defaultListModel.add(++n, e);
            this.setSelectedIndex(n);
        }
    }
}

